import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { } from '../../../../actions';

import { ConceptServices } from '../../../../services/concept-services';
import { TemplatingServices } from '../../../../services/templating-services';

@Component({
  selector: 'app-concept-templating-text',
  templateUrl: './concept-templating-text.component.html',
  styleUrls: ['./concept-templating-text.component.scss']
})
export class ConceptTemplatingTextComponent implements OnInit {
  @Input() propertyMapping;
  @Input() propertyData;
  @Input() tindex;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices,
    private templatingServices: TemplatingServices) { }

  ngOnInit() {
  }

  returnData(propertyData) {
    // this is for when we want to use column data
    if (propertyData === null || propertyData === undefined) { 
      return null
    } else {
      if (propertyData.length > 0) {
        return propertyData;
      } else if (propertyData.propertyValue.length > 0) {
        return propertyData.propertyValue;
      } else {
        return null;
      }
    }
  }

  hasData(propertyData) {
    if (propertyData === null || propertyData === undefined) {
      return false;
    } else {
      if (propertyData.length > 0) {
        return true;
      } else if (propertyData.propertyValue !== undefined && propertyData.propertyValue.length > 0) {
        return true;
      } else {
        return false;
      }
    }
  }
}
